#########################################################
## Copyright (c) 2005
## University of Washington
## Licensed under the terms set forth by University of
## Washington. If you did not sign such a license, you
## are using this software/code illegally and you do not
## have permission to use, modify, or redistribute
## this or any files in this software package.
#########################################################

######################################################
# Constructor
######################################################
EdgeProcess <- function(cmdline, background = FALSE)
{
  proc <- list(cmdline=cmdline, call=sys.call(), background=background, startprog="edge_start")
  class(proc) <- "EdgeProcess"
  proc
}

######################################################
# Start method
# If proc$background is TRUE, then returns the
#   PID of the process that was started
# If proc$background is FALSE, then returns the
#   exit code of the process.
# TO DO: Currently does not return immediately when
#   starting background process, even though
#   edge_start from a terminal command line returns
#   right away!
######################################################
Start.EdgeProcess <- function(proc, ...)
{
  if(class(proc) != "EdgeProcess")
    stop("Object is not of class EdgeProcess")

  ## Find the edge_start executable.
  if(file.access(proc$startprog) < 0)
    stop(paste("Could not acccess executable '", proc$startprog, "'"))

  cmd <- paste(paste(".", .Platform$file.sep, proc$startprog, sep=""), if(proc$background) "-b", proc$cmdline)
print(cmd)
  pid <- system(cmd)
  if(is.na(as.integer(pid)))
    stop("pid is not an integer")
  as.integer(pid)
}

