/*********************************************************
** Copyright (c) 2005
** University of Washington
** Licensed under the terms set forth by University of
** Washington. If you did not sign such a license, you
** are using this software/code illegally and you do not
** have permission to use, modify, or redistribute
** this or any files in this software package.
**
** File: MathUtility.cpp  $Revision: 236 $
**
**********************************************************/
#include "MathUtility.h"
#include <stdexcept>
using namespace std;

/* 
 * Function: CopyVector
 *
 * Copies an array
 */
double* CMathUtility::CopyVector(double* vec, int len)
{
  double* newVec = new double[len];
  if (NULL == newVec)
    throw bad_alloc();

  for(int i = 0; i < len; i++)
    newVec[i] = vec[i];
  return newVec;
}

int* CMathUtility::CopyVector(int* vec, int len)
{
  int* newVec = new int[len];
  if (NULL == newVec)
    throw bad_alloc();

  for(int i = 0; i < len; i++)
    newVec[i] = vec[i];
  return newVec;
}

long* CMathUtility::CopyVector(long* vec, int len)
{
  long* newVec = new long[len];
  if (NULL == newVec)
    throw bad_alloc();

  for(int i = 0; i < len; i++)
    newVec[i] = vec[i];
  return newVec;
}

/* 
 * Function:  DivideVector
 *
 * Divides each element of pNum by the corresponding 
 * member of pDenom. Both vectors must have length len.
 *
 */
void CMathUtility::DivideVector(double *pNum, double *pDenom, int len)
{
  for(int i = 0; i < len; i++)
    {
      pNum[i] = pNum[i]/pDenom[i];
    }
}

