/*********************************************************
** Copyright (c) 2005
** University of Washington
** Licensed under the terms set forth by University of
** Washington. If you did not sign such a license, you
** are using this software/code illegally and you do not
** have permission to use, modify, or redistribute
** this or any files in this software package.
**
** File: RInterfaces.h   $Revision: 274 $
**
**********************************************************/
#ifndef RINTERFACES_H
#define RINTERFACES_H

#include "R.h"
#include "Rdefines.h"
#include "Rinternals.h"

#ifndef EDGE_LIBRARY_VERSION
#define EDGE_LIBRARY_VERSION "Unknown"
#endif

#ifdef __cplusplus
extern "C" {
#endif

  /* This file defines ODP-related functions that are directly callable from R.
   * See RInterfaces.cpp for more detailed comments. */

  /*
   * Gets the current version of the EDGE library.
   */
SEXP GetEdgeLibraryVersion();
  /*
   * Runs an ODP computation in the foreground or in a background thread.
   */

SEXP RunODP(SEXP arglist, SEXP startThread);

  /* 
   * Gets the result of an ODP background thread that has finished.
   */
SEXP GetODPResult(SEXP tid);

  /* 
   * Starts the "intercept" version of the timecourse function  
   * in a background thread
   */
// SEXP RunTimecourseInt(SEXP fit, SEXP res, SEXP v, SEXP v1, 
// 			SEXP H1, SEXP H0, SEXP alpha1, SEXP ind, 
// 			SEXP idx, SEXP eps, SEXP m, SEXP n, 
// 			SEXP N, SEXP nGrp, SEXP B, SEXP startThread);
SEXP RunTimecourseInt(SEXP arglist, SEXP startThread);
  /* 
   * Starts the "no intercept" version of the timecourse function  
   * in a background thread
   */
// SEXP RunTimecourseNoInt(SEXP fit, SEXP res, SEXP v, SEXP rmv, 
// 			  SEXP inc, SEXP H1, SEXP H0,
// 			  SEXP wsq, SEXP ind, SEXP idx, SEXP m, 
// 			  SEXP n, SEXP N, SEXP nGrp, SEXP B,
// 			  SEXP startThread);
SEXP RunTimecourseNoInt(SEXP arglist, SEXP startThread);
  /* 
   * Starts the "indep" version of the timecourse function  
   * in a background thread
   */
// SEXP RunTimecourseIndep(SEXP fit0, SEXP res, SEXP v, SEXP H1, 
// 			  SEXP H0, SEXP B, SEXP m, SEXP n,
// 			  SEXP startThread);

SEXP RunTimecourseIndep(SEXP arglist, SEXP startThread);
  /* 
   * Gets the result of a timecourse background thread that has finished
   * (for any version of the timecourse function)
   */
SEXP GetTimecourseResult(SEXP tid);

#ifdef __cplusplus
}
#endif

#endif
