/*********************************************************
** Copyright (c) 2005
** University of Washington
** Licensed under the terms set forth by University of
** Washington. If you did not sign such a license, you
** are using this software/code illegally and you do not
** have permission to use, modify, or redistribute
** this or any files in this software package.
**
** File: Rintf_cluster.h  $Revision: 237 $
**
**********************************************************/
#ifndef RINTF_CLUSTER_H
#define RINTF_CLUSTER_H

#include "R.h"
#include "Rdefines.h"
#include "Rinternals.h"

extern "C"
{
typedef enum ORDER_METHOD
{
  NONE = 0,
  EISEN = 1,
  OPTIMAL = 2
} ORDER_METHOD;

typedef enum DISTANCE_METHOD
{
  EUCLIDEAN = 0,
  CORRELATION = 1
} DISTANCE_METHOD;

SEXP Cluster(SEXP sexpData, SEXP sexpRows, SEXP sexpCols, SEXP sexpMerge, SEXP sexpHeight, SEXP sexpOrder, SEXP sexpOrderMethod, SEXP sexpDistanceMethod);

  // Clustering thread

  // Starts a clustering thread.
  SEXP StartClusteringThread(SEXP sexpData, SEXP sexpRows, SEXP sexpCols,
			      SEXP sexpOrderMethod, 
			      SEXP sexpDistanceMethod);

  // Gathers the results of a finished clustering thread.
  SEXP FinishClusteringThread(SEXP threadid,
			      SEXP sexpMerge, 
			      SEXP sexpHeight, 
			      SEXP sexpOrder);

}

// Utility functions
TDoubleVector** VectorizeRMatrix(double* rmatrix, int nrow, int ncol);
double GetHeight(CClusterNode* pNode, double* pHeights, int heightLen);

// Utility classes
/* Builds an R-style "merge" list describing a hierarchical cluster */
class CLeafOrdering : public CClusterNodeFunction
{
 public:
  CLeafOrdering(int *pOrder)
    : m_pOrder(pOrder), m_current(0)
  {
  }

  void Go(CClusterNode* pNode);

 private:
  int *m_pOrder;
  int m_current;
};

#endif
