/*********************************************************
** Copyright (c) 2005
** University of Washington
** Licensed under the terms set forth by University of
** Washington. If you did not sign such a license, you
** are using this software/code illegally and you do not
** have permission to use, modify, or redistribute
** this or any files in this software package.
**
** File: TimecourseIntercept.cpp  $Revision: 275 $
**
**********************************************************/
#include "edge.h"
#include "TimecourseIntercept.h"
#include "MathUtility.h"

int CTimecourseIntercept::Go(THREAD_ID_T tid)
{
  nullFLongInt(m_pFit, m_pRes, m_pv, m_pv1, m_pH1,
	       m_pH0, m_pAlpha1, m_pInd, m_pIdx, &m_eps, 
	       &m_m, &m_n, &m_N, m_pNGrp, &m_B, m_pResult,
		 UpdateProgressThreadProgress, this);

  SetReturnData(m_pResult, m_m * m_B);

  return 0;
}

// CTimecourseIntercept::CTimecourseIntercept(double *pFit, double *pRes, int *pv, int *pv1, 
// 			 double *pH1, double *pH0, double *pAlpha1, int *pInd, int *pIdx, double eps, 
// 			 long m, long n, long N, int *pNGrp, long B)

CTimecourseIntercept::CTimecourseIntercept(SEXP arglist)
{
  SEXP arg;
  int m_Fitlen;
  int m_Reslen;
  int m_vlen;
  int m_v1len;
  int m_H1len;
  int m_H0len;
  int m_Alpha1len;
  int m_Indlen;
  int m_Idxlen;

#ifdef EDGE_DEBUG
fprintf(stderr,"begin constructor for CTimecourseIntercept\n");
#endif
    assert(length(arglist)>=26);
// fit0
     arg=VECTOR_ELT(arglist,10);
     m_Fitlen=length(arg);
     m_pFit=CMathUtility::CopyVector(REAL(arg),m_Fitlen);
// res0
     arg=VECTOR_ELT(arglist,16);
     m_Reslen=length(arg);
     m_pRes=CMathUtility::CopyVector(REAL(arg),m_Reslen);
// v-1, when do we subtract 1?
     arg=VECTOR_ELT(arglist,11);
     m_vlen=length(arg);
     m_pv=CMathUtility::CopyVector(INTEGER(arg),m_vlen);
// v1 ???
     arg=VECTOR_ELT(arglist,23);
     m_v1len=length(arg);
     m_pv1=CMathUtility::CopyVector(INTEGER(arg),m_v1len);
// H1
     arg=VECTOR_ELT(arglist,13);
     m_H1len=length(arg);
     m_pH1=CMathUtility::CopyVector(REAL(arg),m_H1len);
// H0
     arg=VECTOR_ELT(arglist,12);
     m_H0len=length(arg);
     m_pH0=CMathUtility::CopyVector(REAL(arg),m_H0len);
// alpha1
     arg=VECTOR_ELT(arglist,19);
     m_Alpha1len=length(arg);
     m_pAlpha1=CMathUtility::CopyVector(REAL(arg),m_Alpha1len);
// Ind
     arg=VECTOR_ELT(arglist,9);
     m_Indlen=length(arg);
     m_pInd=CMathUtility::CopyVector(INTEGER(arg),m_Indlen);
// Idx
     arg=VECTOR_ELT(arglist,25);
     m_Idxlen=length(arg);
     m_pIdx=CMathUtility::CopyVector(INTEGER(arg),m_Idxlen);
// m
     arg=VECTOR_ELT(arglist,4);
     m_m=INTEGER(arg)[0];
// n
     arg=VECTOR_ELT(arglist,5);
     m_n=INTEGER(arg)[0];
// eps
     arg=VECTOR_ELT(arglist,20);
     m_eps=REAL(arg)[0];
// N
     arg=VECTOR_ELT(arglist,22);
     m_N=INTEGER(arg)[0];
// NGrp
     arg=VECTOR_ELT(arglist,26);
     m_NGrplen=length(arg);
     m_pNGrp=CMathUtility::CopyVector(INTEGER(arg),m_NGrplen);
// B
     arg=VECTOR_ELT(arglist,0);
     m_B=INTEGER(arg)[0];


  m_pResult = new double[m_m*m_B];
}

CTimecourseIntercept::~CTimecourseIntercept() 
{
  delete [] m_pFit;
  delete [] m_pRes;
  delete [] m_pv;
  delete [] m_pv1;
  delete [] m_pAlpha1;
  delete [] m_pH0;
  delete [] m_pH1;
  delete [] m_pInd;
  delete [] m_pIdx;
  delete [] m_pNGrp;
  delete [] m_pResult;
}
