/*********************************************************
** Copyright (c) 2005
** University of Washington
** Licensed under the terms set forth by University of
** Washington. If you did not sign such a license, you
** are using this software/code illegally and you do not
** have permission to use, modify, or redistribute
** this or any files in this software package.
**
** File: TimecourseIntercept.h
**
**********************************************************/
#ifndef TIMECOURSEINTERCEPT_H
#define TIMECOURSEINTERCEPT_H

#include "R.h"
#include "Rdefines.h"
#include "Rinternals.h"

#include "ProgressThread.h"

void CheckLength(long actLength, const char* argName, long expLength);


/*
 * Class for computing the timecourse algorithm ("intercept")
 * using threads.
 * This class does the work of threading; all the computation
 * is done by original timecourse functions in edge.c
 * See also TimecourseIntercept.h and TimecourseNoIntercept.h
 */
class CTimecourseIntercept : public CProgressThread
{
 public:
//  CTimecourseIntercept(double *pFit, double *pRes, int *pv, int *pv1, 
//   double *pH0, double *pH1, double *pAlpha1, int *pInd, int *pIdx, 
//   double eps, long m, long n, long N, int *pNGrp, long B);
  CTimecourseIntercept(SEXP arglist);
  virtual ~CTimecourseIntercept();

  int Go(THREAD_ID_T tid);

 private:
  double *m_pFit;
  double *m_pRes;
  int *m_pv;
  int *m_pv1;
  double *m_pH1;
  double *m_pH0;
  double *m_pAlpha1;
  int *m_pInd;
  int *m_pIdx;
  double m_eps;
  long m_m;
  long m_n;
  int m_NGrplen;
  int *m_pNGrp;
  long m_N;
  long m_B;
  double *m_pResult;
};

#endif
