/*********************************************************
** Copyright (c) 2005
** University of Washington
** Licensed under the terms set forth by University of
** Washington. If you did not sign such a license, you
** are using this software/code illegally and you do not
** have permission to use, modify, or redistribute
** this or any files in this software package.
**
** File: TimecourseNoIntercept.cpp  $Revision: 275 $
**
**********************************************************/

#include <iostream>
#include "edge.h"
#include "TimecourseNoIntercept.h"
#include "MathUtility.h"

// make debug will #define EDGE_DEBUG
#ifdef EDGE_DEBUG
#define xerr(a) cerr << #a "[0]=" << a[0] << "\n";
#define yerr(a) cerr << #a "=" << a << "\n";
//     cerr << "length(arglist)" << length(arglist) << "\n";
#else
#define xerr(a)
#define yerr(a)
#endif

int CTimecourseNoIntercept::Go(THREAD_ID_T tid)
{
  nullFLongNoInt(m_pFit, m_pRes, m_pv, m_prmv, m_pInc, m_pH1, m_pH0, m_pwsq, m_pInd, m_pIdx, 
		 &m_m, &m_n, &m_N, m_pNGrp, &m_B, m_pResult,
		 UpdateProgressThreadProgress, this);

  SetReturnData(m_pResult, m_m * m_B);

  return 0;
}

// CTimecourseNoIntercept::CTimecourseNoIntercept(double *pFit, double *pRes, int *pv, int *prmv, int *pInc, 
// 					       double *pH1, double *pH0, double *pwsq, int *pInd, int *pIdx, 
// 					       long m, long n, long N, int *pNGrp, long B)
CTimecourseNoIntercept::CTimecourseNoIntercept(SEXP arglist)
//  : m_pFit(CMathUtility::CopyVector(pFit, m*n)), 
//    m_pRes(CMathUtility::CopyVector(pRes, m*(n-N))), 
//    m_pv(CMathUtility::CopyVector(pv, (n-N)*B)), 
//    m_prmv(CMathUtility::CopyVector(prmv, N)), 
//    m_pInc(CMathUtility::CopyVector(pInc, n-N)), 
//    m_pH0(CMathUtility::CopyVector(pH0, n*n)), 
//    m_pH1(CMathUtility::CopyVector(pH1, n*n)), 
//    m_pwsq(CMathUtility::CopyVector(pwsq, (n-N)*(n-N))), 
//    m_pInd(CMathUtility::CopyVector(pInd, n)), 
//    m_pIdx(CMathUtility::CopyVector(pIdx, n)), 
//    m_m(m), m_n(n), m_N(N),
//    m_pNGrp(CMathUtility::CopyVector(pNGrp, N)), m_B(B)

{
// gah - arg is a temporary for argument extraction
//  We are not creating any new R objects, only reading existing ones
//  and copying to C++ class instance variables, so we shouldn't need
//  to do any PROTECTing.

  SEXP arg;
  int m_Fitlen;
  int m_Reslen;
  int m_vlen;
  int m_Inclen;
  int m_H1len;
  int m_H0len;
  int m_wsqlen;
  int m_Indlen;
  int m_Idxlen;
  int m_rmvlen;
  int m_NGrplen;

#ifdef EDGE_DEBUG
fprintf(stderr,"begin constructor for CTimecourseNoIntercept\n");
#endif
   assert(length(arglist)>=27);

// fit0
     arg=VECTOR_ELT(arglist,10);
     m_Fitlen=length(arg);
     m_pFit=CMathUtility::CopyVector(REAL(arg),m_Fitlen);
xerr(m_pFit);
// res00
     arg=VECTOR_ELT(arglist,17);
     m_Reslen=length(arg);
     m_pRes=CMathUtility::CopyVector(REAL(arg),m_Reslen);
xerr(m_pRes);
// v-1, when do we subtract 1?
     arg=VECTOR_ELT(arglist,11);
     m_vlen=length(arg);
     m_pv=CMathUtility::CopyVector(INTEGER(arg),m_vlen);
xerr(m_pv);
// rmv 
     arg=VECTOR_ELT(arglist,18);
     m_rmvlen=length(arg);
     m_prmv=CMathUtility::CopyVector(INTEGER(arg),m_rmvlen);
xerr(m_prmv);
// Inc 
     arg=VECTOR_ELT(arglist,24);
     m_Inclen=length(arg);
     m_pInc=CMathUtility::CopyVector(INTEGER(arg),m_Inclen);
xerr(m_pInc);
// H1
     arg=VECTOR_ELT(arglist,13);
     m_H1len=length(arg);
     m_pH1=CMathUtility::CopyVector(REAL(arg),m_H1len);
xerr(m_pH1);
// H0
     arg=VECTOR_ELT(arglist,12);
     m_H0len=length(arg);
     m_pH0=CMathUtility::CopyVector(REAL(arg),m_H0len);
xerr(m_pH0);
// wsq
     arg=VECTOR_ELT(arglist,21);
     m_wsqlen=length(arg);
     m_pwsq=CMathUtility::CopyVector(REAL(arg),m_wsqlen);
xerr(m_pwsq);
// Ind
     arg=VECTOR_ELT(arglist,9);
     m_Indlen=length(arg);
     m_pInd=CMathUtility::CopyVector(INTEGER(arg),m_Indlen);
xerr(m_pInd);
// Idx
     arg=VECTOR_ELT(arglist,25);
     m_Idxlen=length(arg);
     m_pIdx=CMathUtility::CopyVector(INTEGER(arg),m_Idxlen);
xerr(m_pIdx);
// m
     arg=VECTOR_ELT(arglist,4);
     m_m=INTEGER(arg)[0];
yerr(m_m);
// n
     arg=VECTOR_ELT(arglist,5);
     m_n=INTEGER(arg)[0];
yerr(m_n);
// N
     arg=VECTOR_ELT(arglist,22);
     m_N=INTEGER(arg)[0];
yerr(m_N);
// NGrp
     arg=VECTOR_ELT(arglist,26);
     m_NGrplen=length(arg);
     m_pNGrp=CMathUtility::CopyVector(INTEGER(arg),m_NGrplen);
xerr(m_pNGrp);
// B
     arg=VECTOR_ELT(arglist,0);
     m_B=INTEGER(arg)[0];
yerr(m_B);

  m_pResult = new double[m_m*m_B];

// Sanity check moved from RInterfaces.cpp

  CheckLength(m_Fitlen, "fit", m_m*m_n);
  CheckLength(m_Reslen, "res", m_m*(m_n - m_N));
  CheckLength(m_vlen, "v", (m_n-m_N)*m_B);
  CheckLength(m_rmvlen, "rmv", m_N);
  CheckLength(m_Inclen, "inc", m_n-m_N);
  CheckLength(m_H1len, "H1", m_n*m_n);
  CheckLength(m_H0len, "H0", m_n*m_n);
  CheckLength(m_wsqlen, "wsq", (m_n-m_N)*(m_n-m_N));
  CheckLength(m_Indlen, "ind", m_n);
  CheckLength(m_Idxlen, "idm_", m_n);
  CheckLength(m_NGrplen, "nGrp", m_N);

}

CTimecourseNoIntercept::~CTimecourseNoIntercept() 
{
  delete [] m_pFit;
  delete [] m_pRes;
  delete [] m_pv;
  delete [] m_prmv;
  delete [] m_pInc;
  delete [] m_pH0;
  delete [] m_pH1;
  delete [] m_pwsq;
  delete [] m_pInd;
  delete [] m_pIdx;
  delete [] m_pNGrp;
  delete [] m_pResult;
}
