/*********************************************************
** Copyright (c) 2005
** University of Washington
** Licensed under the terms set forth by University of
** Washington. If you did not sign such a license, you
** are using this software/code illegally and you do not
** have permission to use, modify, or redistribute
** this or any files in this software package.
**
** File: TimecourseNoIntercept.h  $Revision: 275 $
**
**********************************************************/
#ifndef TIMECOURSENOINTERCEPT_H
#define TIMECOURSENOINTERCEPT_H

#include "R.h"
#include "Rdefines.h"
#include "Rinternals.h"

#include "ProgressThread.h"

void CheckLength(long actLength, const char* argName, long expLength);

/*
 * Class for computing the timecourse algorithm ("no intercept")
 * using threads.
 * This class does the work of threading; all the computation
 * is done by original timecourse functions in edge.c
 * See also TimecourseIntercept.h and TimecourseNoIntercept.h
 */
class CTimecourseNoIntercept : public CProgressThread
{
 public:
//  CTimecourseNoIntercept(double *pFit, double *pRes, int *pv, int *prmv, 
//   int *pInc, double *pH0, double *pH1, double *pwsqR, int *pInd, int *pIdx, 
//   long m, long n, long N, int *pNGrp, long B);
  CTimecourseNoIntercept(SEXP arglist);
  virtual ~CTimecourseNoIntercept();

  int Go(THREAD_ID_T tid);

 private:
  double *m_pFit;
  double *m_pRes;
  int *m_pv;
  int *m_prmv;
  int *m_pInc;
  double *m_pH0;
  double *m_pH1;
  double *m_pwsq;
  int *m_pInd;
  int *m_pIdx;
  long m_m;
  long m_n;
  long m_N;
  int *m_pNGrp;
  long m_B;
  double *m_pResult;
};

#endif
