/*********************************************************
** Copyright (c) 2005
** University of Washington
** Licensed under the terms set forth by University of
** Washington. If you did not sign such a license, you
** are using this software/code illegally and you do not
** have permission to use, modify, or redistribute
** this or any files in this software package.
**
** File: TimecourseThread.cpp  $Revision: 275 $
**
**********************************************************/
#include "edge.h"
#include "TimecourseThread.h"
#include "MathUtility.h"

int CTimecourseThread::Go(THREAD_ID_T tid)
{
  nullFIndep(m_pFit0, m_pRes, m_pv, m_pH1, m_pH0, &m_m, &m_n, &m_B, m_pResult,
	   UpdateProgressThreadProgress, this);

  SetReturnData(m_pResult, m_m*m_B);

  return 0;
}

// CTimecourseThread::CTimecourseThread(double *pFit0, double *pRes, int *pv, double *pH1, 
// 				     double *pH0, long B, long m, long n) 
 CTimecourseThread::CTimecourseThread(SEXP arglist)
//  : m_pFit0(CMathUtility::CMathUtility::CopyVector(pFit0, m*n)), 
//    m_pRes(CMathUtility::CMathUtility::CopyVector(pRes, m*n)), 
//    m_pv(CMathUtility::CMathUtility::CopyVector(pv, n*B)), 
//    m_pH1(CMathUtility::CMathUtility::CopyVector(pH1, n*n)), 
//    m_pH0(CMathUtility::CMathUtility::CopyVector(pH0, n*n)), 
//    m_B(B), m_m(m), m_n(n)
{
  SEXP arg;
  int m_Fitlen;
  int m_Reslen;
  int m_vlen;
  int m_H1len;
  int m_H0len;

#ifdef EDGE_DEBUG
fprintf(stderr,"begin constructor for CTimecourseThread\n");
#endif
  assert(length(arglist)>=16);

// fit0
     arg=VECTOR_ELT(arglist,10);
     m_Fitlen=length(arg);
     m_pFit0=CMathUtility::CopyVector(REAL(arg),m_Fitlen);
// res
     arg=VECTOR_ELT(arglist,15);
     m_Reslen=length(arg);
     m_pRes=CMathUtility::CopyVector(REAL(arg),m_Reslen);
// v-1, when do we subtract 1?
     arg=VECTOR_ELT(arglist,11);
     m_vlen=length(arg);
     m_pv=CMathUtility::CopyVector(INTEGER(arg),m_vlen);
// H1
     arg=VECTOR_ELT(arglist,13);
     m_H1len=length(arg);
     m_pH1=CMathUtility::CopyVector(REAL(arg),m_H1len);
// H0
     arg=VECTOR_ELT(arglist,12);
     m_H0len=length(arg);
     m_pH0=CMathUtility::CopyVector(REAL(arg),m_H0len);
// m
     arg=VECTOR_ELT(arglist,4);
     m_m=INTEGER(arg)[0];
// n
     arg=VECTOR_ELT(arglist,5);
     m_n=INTEGER(arg)[0];
// B
     arg=VECTOR_ELT(arglist,0);
     m_B=INTEGER(arg)[0];

  m_pResult = new double[m_m*m_B];

// gah - sanity checks moved from RInterfaces.cpp
  CheckLength(m_Fitlen, "fit0", m_m*m_n);
  CheckLength(m_Reslen, "res", m_m*m_n);
  CheckLength(m_vlen, "v", m_n*m_B);
  CheckLength(m_H0len, "H0", m_n*m_n);
  CheckLength(m_H1len, "H1", m_n*m_n);

#ifdef EDGE_DEBUG
fprintf(stderr,"end constructor for CTimecourseThread\n");
#endif
}

CTimecourseThread::~CTimecourseThread() 
{
  delete [] m_pFit0;
  delete [] m_pRes;
  delete [] m_pv;
  delete [] m_pH0;
  delete [] m_pH1;
  delete [] m_pResult;
}
