/*********************************************************
** Copyright (c) 2005
** University of Washington
** Licensed under the terms set forth by University of
** Washington. If you did not sign such a license, you
** are using this software/code illegally and you do not
** have permission to use, modify, or redistribute
** this or any files in this software package.
**
** File: TimecourseThread.h  $Revision: 275 $
**
**********************************************************/
#ifndef TIMECOURSETHREAD_H
#define TIMECOURSETHREAD_H

#include "R.h"
#include "Rdefines.h"
#include "Rinternals.h"

#include "ProgressThread.h"

void CheckLength(long actLength, const char* argName, long expLength);

/*
 * Class for computing the timecourse algorithm using threads.
 * This class does the work of threading; all the computation
 * is done by original timecourse functions in edge.c
 * See also TimecourseIntercept.h and TimecourseNoIntercept.h
 */
class CTimecourseThread : public CProgressThread
{
 public:
//  CTimecourseThread(double *pFit0, double *pRes, int *pv, double *pH0, 
//   double *pH1, long B, long m, long n);
  CTimecourseThread(SEXP arglist);
  virtual ~CTimecourseThread();

  int Go(THREAD_ID_T tid);

 private:
  double *m_pFit0;
  double *m_pRes;
  int *m_pv;
  double *m_pH1;
  double *m_pH0;
  long m_B;
  long m_m;
  long m_n;
  double *m_pResult;
};

#endif
