/*********************************************************
** Copyright (c) 2005
** University of Washington
** Licensed under the terms set forth by University of
** Washington. If you did not sign such a license, you
** are using this software/code illegally and you do not
** have permission to use, modify, or redistribute
** this or any files in this software package.
**
** File: BasicCluster.h
**
**********************************************************/
#ifndef BASICCLUSTER_H
#define BASICCLUSTER_H

#include "ClusterNode.h"
#include "Cluster.h"
#include "UpperDiagonalMatrix.h"

class CBasicCluster : public CCluster
{
 public:
  CBasicCluster(CDistanceFunction* pDist, CCombineDataFunction* pCombineData)
    : CCluster(pDist, pCombineData), m_pDistances(NULL), m_ppNodes(NULL) {}

  virtual ~CBasicCluster();
  CClusterNode* Cluster(void **pData, int iDataCount);
  CMatrix* GetDistanceMatrix();
  CClusterNode* GetNodeByIndex(int index);
  void SetNodeByIndex(int index, CClusterNode* node);
  double GetCachedDistance(CClusterNode* pNode1, CClusterNode* pNode2);
  /* Returns number of bytes required to cluster data with given size & count */
  uintmax_t GetMemoryRequirement(uintmax_t iDataSize, uintmax_t iDataCount);

 private:

  CUpperDiagonalMatrix* m_pDistances;

  CClusterNode** m_ppNodes;

};


#endif
