/*********************************************************
** Copyright (c) 2005
** University of Washington
** Licensed under the terms set forth by University of
** Washington. If you did not sign such a license, you
** are using this software/code illegally and you do not
** have permission to use, modify, or redistribute
** this or any files in this software package.
**
** File: ClusterException.h
**
**********************************************************/
#ifndef __CLUSTEREXCEPTION__
#define __CLUSTEREXCEPTION__

#include <exception>
#include <sstream>
#include <string>
using namespace std;

class CClusterException : public exception
{
 public:
  ~CClusterException() throw()
  {
  }

  CClusterException(int id)
  {
    m_iId = id;
    m_sMessage = "cluster exception";
  }

  CClusterException(int id, const char* pMessage)
  {
    m_iId = id;
    m_sMessage = pMessage;
  }

  CClusterException(int id, const char* pFile, const int line, const char* pMessage)
  { 
    m_iId = id;
    std::stringstream strm;
    strm << "cluster exception at " << pFile << ": " << line << ": " << pMessage;
    m_sMessage = strm.str();
  }

  CClusterException(int id, const char* pFile, const int line)
  {
    m_iId = id;
    std::stringstream strm;
    strm << "cluster exception at " << pFile << ": " << line;
    m_sMessage = strm.str();
  }
  
  string Message()
  {
    return m_sMessage;
  }
  
  int Id()
  {
    return m_iId;
  }

 private:
  string m_sMessage;
  int m_iId;
};

enum ClusterExceptionIds {
  CLUSTEX_OUTOFMEMORY = 1,
  CLUSTEX_REUSEDMETHOD = 2,
  CLUSTEX_MISSINGDISTANCEFUN = 3,
  CLUSTEX_NULLARG = 4,
  CLUSTEX_OUTOFRANGE = 5
};



#ifdef DEBUG
#define __throw_cluster_ex(ID, MESSAGE) throw new CClusterException(ID, __FILE__, __LINE__, MESSAGE)
#else
#define __throw_cluster_ex(ID, MESSAGE) throw new CClusterException(ID, MESSAGE)
#endif

#define __catch_badalloc(EXPR) try { (EXPR); } catch(bad_alloc&) { __throw_cluster_ex(CLUSTEX_OUTOFMEMORY, "Clustering operation failed due to lack of memory"); }

#endif
