/*********************************************************
** Copyright (c) 2005
** University of Washington
** Licensed under the terms set forth by University of
** Washington. If you did not sign such a license, you
** are using this software/code illegally and you do not
** have permission to use, modify, or redistribute
** this or any files in this software package.
**
** File: ClusterNodeVector.h
**
**********************************************************/
#ifndef CLUSTERNODEVECTOR_H
#define CLUSTERNODEVECTOR_H

#include <stdlib.h>
#include <stdio.h>
#include "ClusterNode.h"

#include <exception>
#include <new>

using namespace std;

#define CLUSTERNODEVECTOR_INITIAL_CAP 50
#define CLUSTERNODEVECTOR_INCREMENT 40

class invalid_index : public std::exception
{
  const char* what() { return "invalid index"; }
};

class CClusterNodeVector_iterator;
class CClusterNodeVector;

class CClusterNode;

class CClusterNodeVector_iterator 
{
  friend class CClusterNodeVector;
 public:
  CClusterNodeVector_iterator(CClusterNodeVector* pVec, int initialPos = 0) 
    : m_cur(initialPos), m_pVec(pVec)
  {
    if (NULL == pVec)
      throw bad_alloc();
  }
  
  bool operator==(const CClusterNodeVector_iterator& i1);
  bool operator!=(const CClusterNodeVector_iterator& i1);
  void operator++(int);
  CClusterNode* operator*();
  
 protected:
  int m_cur;
  CClusterNodeVector* m_pVec;
};

class CClusterNodeVector
{

 public:
  typedef CClusterNodeVector_iterator iterator;

  friend class CClusterNodeVector_iterator;

  CClusterNodeVector(int size);
  ~CClusterNodeVector();

  void push_back(CClusterNode* obj);
  void insert(iterator iter, iterator start, iterator finish);
  void insert(iterator before, CClusterNode* pNode);
  long size() { return m_endIndex; }
  long capacity() { return m_cap; }

  iterator begin();
  
  iterator end() { return m_endIter; }

 protected:
  void Reallocate(int newCap);

  CClusterNode** m_pVec;
  long m_cap;
  long m_endIndex;
  CClusterNodeVector_iterator m_endIter;

};



inline bool operator==(CClusterNodeVector_iterator& i1, CClusterNodeVector_iterator& i2);

#endif
