/*********************************************************
** Copyright (c) 2005
** University of Washington
** Licensed under the terms set forth by University of
** Washington. If you did not sign such a license, you
** are using this software/code illegally and you do not
** have permission to use, modify, or redistribute
** this or any files in this software package.
**
** File: ClusterThread.h
**
**********************************************************/
#ifndef CLUSTERTHREAD_H
#define CLUSTERTHREAD_H

#include "ProgressThread.h"
#include "Cluster.h"
#include "VectorDataFunctions.h"
#include "Ordering.h"

/*
 * CClusterThread
 * Wrapper class for threaded clustering.
 */
class CClusterThread : public CProgressThread
{
 public:
  CClusterThread(CCluster* pCluster, TDoubleVector** pData, int dataCount, COrdering *pOrdering, bool deleteAll);
  virtual ~CClusterThread();

  int Go(THREAD_ID_T tid);
  void CleanupForTermination();

  CClusterNode* GetResult() { return m_pResult; }
  void SetResult(CClusterNode* pResult) { SetProperty((void**)&m_pResult, (void*)pResult); }
  CCluster* GetClusterer() { return m_pCluster; }
  int GetDataCount() { return m_dataCount; }

  TDoubleVector** GetData() { return m_pInData; }
  COrdering* GetOrdering() { return m_pOrdering; }

 private:
  CCluster* m_pCluster;
  TDoubleVector** m_pInData;
  int m_dataCount;
  COrdering* m_pOrdering;
  CClusterNode* m_pResult;
  bool m_bDeleteAll;
};

#endif
