/*********************************************************
** Copyright (c) 2005
** University of Washington
** Licensed under the terms set forth by University of
** Washington. If you did not sign such a license, you
** are using this software/code illegally and you do not
** have permission to use, modify, or redistribute
** this or any files in this software package.
**
** File: CostMap.h
**
**********************************************************/
#ifndef COSTMAP_H
#define COSTMAP_H

#include <vector>
#include <algorithm>

using namespace std;

typedef pair<double, int> CostPairType;

// This struct defines a () operator,
// taking two PairType arguments and 
// returning a Boolean: True if 
// x < y and False otherwise.
//
// This is the format required for 
// ordering used in the STL sort()
// function.
//
struct less_CostPairType : public binary_function<CostPairType, CostPairType, bool> {
  bool operator()(CostPairType x, CostPairType y) 
  { 
    return x.first < y.first;
  }
};

// This class is essentially a sortable vector,
// used by COptimalOrdering::ComputeCosts().
class CCostMap
{
 public:
  typedef vector<CostPairType>::iterator iterator;

  iterator begin()
  {
    return m_vec.begin();
  }
  
  iterator end()
  {
    return m_vec.end();
  }

  void insert(CostPairType p) 
  { 
    m_vec.push_back(p);
  }

  void sort()
  {
    std::sort(m_vec.begin(), m_vec.end(), less_CostPairType());
  }

 private:
  vector<CostPairType> m_vec;

};

#endif

