/*********************************************************
** Copyright (c) 2005
** University of Washington
** Licensed under the terms set forth by University of
** Washington. If you did not sign such a license, you
** are using this software/code illegally and you do not
** have permission to use, modify, or redistribute
** this or any files in this software package.
**
** File: EisenOrdering.h
**
**********************************************************/
#ifndef EISENORDERING_H
#define EISENORDERING_H

#include "Ordering.h"
#include "ClusterNode.h"
#include <map>

using namespace std;

class CWeightFunction
{
 public:
  virtual ~CWeightFunction() {}
  virtual double GetWeight(CClusterNode* pNode) = 0;
};

/* Class that does leaf ordering on clustering data by weighting. */
class CEisenOrdering : public COrdering
{
 public:
  CEisenOrdering();
  CEisenOrdering(CWeightFunction* pWeight);
  virtual ~CEisenOrdering();

  void OrderLeaves(CClusterNode* pCluster, CMatrix* pDistances);
  uintmax_t GetMemoryRequirement(CClusterNode* pCluster, CMatrix* pDistances);

 private:
  void OrderLeavesRecursive(CClusterNode* pCluster, CMatrix* pDistances);

  CWeightFunction *m_pWeight;
  bool m_freeWeight;
  int m_trackerTotal;
  int m_tracker;
};

class CAverageWeight : public CWeightFunction
{
 public:
  virtual ~CAverageWeight() {}
  double GetWeight(CClusterNode* pNode);

};

class CTimeOfMaxExpression : public CWeightFunction
{
 public:
  virtual ~CTimeOfMaxExpression() {}
  double GetWeight(CClusterNode* pNode);

};


#endif

