/*********************************************************
** Copyright (c) 2005
** University of Washington
** Licensed under the terms set forth by University of
** Washington. If you did not sign such a license, you
** are using this software/code illegally and you do not
** have permission to use, modify, or redistribute
** this or any files in this software package.
**
** File: Ordering.h
**
**********************************************************/
#ifndef ORDERING_H
#define ORDERING_H

#include "ClusterNode.h"
#include "Matrix.h"
#include "IProgressThreadCallback.h"
#include <stdint.h>

/* base class for leaf ordering algorithms */
class COrdering : public IProgressThreadCallback
{
 public:
  virtual ~COrdering() {}
  virtual void OrderLeaves(CClusterNode* pCluster, CMatrix* pDistances) = 0;
  virtual uintmax_t GetMemoryRequirement(CClusterNode* pCluster, CMatrix* pDistances) = 0;
};

#endif
