/*********************************************************
** Copyright (c) 2005
** University of Washington
** Licensed under the terms set forth by University of
** Washington. If you did not sign such a license, you
** are using this software/code illegally and you do not
** have permission to use, modify, or redistribute
** this or any files in this software package.
**
** File: TestException.h
**
**********************************************************/
#ifndef __TESTEXCEPTION__
#define __TESTEXCEPTION__
#include <exception>
#include <string>
#include <sstream>

using namespace std;

class CTestException : public exception
{
 public:
  CTestException(string message)
    : m_message(message)
  {
  }

  CTestException(string file, int line, string message)
  {
    std::stringstream strm;
    strm << "Test exception at " << file << ": " << line << ": " << message;
    m_message = strm.str();

  }
  
  CTestException(string file, int line)
  {
    std::stringstream strm;
    strm << "Test exception at " << file << ": " << line;
    m_message = strm.str();
  }

  ~CTestException() throw()
  {
  }

  string Message()
  {
    return m_message;
  }

 private:
  string m_message;

};

#define __throw_no_message throw new CTestException(__FILE__, __LINE__)
#define __throw_message(MESSAGE) throw new CTestException(__FILE__, __LINE__, MESSAGE);
#define __test_assert(CONDITION, MESSAGE) do { if (!(CONDITION)) __throw_message(MESSAGE) } while(0)
#define __test_assert_nomsg(CONDITION) do { if (!(CONDITION)) __throw_message("Assert failed") } while(0)

#endif
