/*********************************************************
** Copyright (c) 2005
** University of Washington
** Licensed under the terms set forth by University of
** Washington. If you did not sign such a license, you
** are using this software/code illegally and you do not
** have permission to use, modify, or redistribute
** this or any files in this software package.
**
** File: UnitTestClass.cpp
**
**********************************************************/
#include "UnitTestClass.h"
#include <iostream>
using namespace std;

CUnitTestClass::CUnitTestClass(string sName)
  : m_sName(sName), m_failures(0)
{
}

string CUnitTestClass::GetName()
{
  return m_sName;
}

void CUnitTestClass::Run()
{
  m_failures = 0;
  m_passes = 0;
  cout << GetName() << ": Start\n";
  RunTests();
  cout << GetName() << ": Done (" << m_failures << " failed)\n";
}

int CUnitTestClass::GetFailureCount()
{
  return m_failures;
}

int CUnitTestClass::GetPassCount()
{
  return m_passes;
}

void CUnitTestClass::ReportFailure()
{
  cout << "FAILED\n";
  m_failures++;
}

void CUnitTestClass::ReportSuccess()
{
  m_passes++;
  cout << "SUCCEEDED\n";
}

void CUnitTestClass::BeginTest(string sTestName)
{
  cout << "    " << sTestName << "...";
}

void CUnitTestClass::EndTest(bool pass)
{
  if(!pass)
    ReportFailure();
  else
    ReportSuccess();
}
