/*********************************************************
** Copyright (c) 2005
** University of Washington
** Licensed under the terms set forth by University of
** Washington. If you did not sign such a license, you
** are using this software/code illegally and you do not
** have permission to use, modify, or redistribute
** this or any files in this software package.
**
** File: UnitTestClass.h
**
**********************************************************/
#ifndef __UNITTESTCLASS_H__
#define __UNITTESTCLASS_H__

#include <string>
using namespace std;

class CUnitTestClass
{
 public:
  CUnitTestClass(string sName);
  void Run();
  string GetName();
  int GetFailureCount();
  int GetPassCount();

 protected:
  virtual void RunTests() = 0;
  void ReportFailure();
  void ReportSuccess();
  void BeginTest(string sTestName);
  void EndTest(bool success);

 private:
  string m_sName;
  int m_failures;
  int m_passes;
};

#endif
