/*********************************************************
** Copyright (c) 2005
** University of Washington
** Licensed under the terms set forth by University of
** Washington. If you did not sign such a license, you
** are using this software/code illegally and you do not
** have permission to use, modify, or redistribute
** this or any files in this software package.
**
** File: UnitTestRunner.cpp
**
**********************************************************/
#include "UnitTestRunner.h"
#include <iostream>
using namespace std;

CUnitTestRunner::CUnitTestRunner()
{
}

void CUnitTestRunner::AddObject(CUnitTestClass* pClass, string sName)
{
  m_vecTests.insert(m_vecTests.end(), TNamedTest(sName, pClass));
}

int CUnitTestRunner::Run()
{
  vector<TNamedTest>::iterator iter = m_vecTests.begin();
  for(; iter != m_vecTests.end(); iter++)
    {
      cout << "----------\n";
      (*iter).second->Run();
    }

  int totalFailures = 0;
  int totalPasses = 0;
  int failures;
  int passes;
  for(iter = m_vecTests.begin(); iter != m_vecTests.end(); iter++)
    {
      totalFailures += (failures = (*iter).second->GetFailureCount());
      totalPasses += (passes = (*iter).second->GetPassCount());
      cout << (*iter).first << ": " << failures << " failed\n";
    }

  cout << "----------- TESTS FINISHED ---------------\nTOTAL FAILURES: " << totalFailures << "\nTOTAL PASSES: " << totalPasses << "\n";
  return totalFailures;
}

void CUnitTestRunner::DeleteTests()
{
  vector<TNamedTest>::iterator iter = m_vecTests.begin();
  for(; iter != m_vecTests.end(); iter++)
    {
      delete (*iter).second;
      (*iter).second = (CUnitTestClass*)0;
    }
}
