/*********************************************************
** Copyright (c) 2005
** University of Washington
** Licensed under the terms set forth by University of
** Washington. If you did not sign such a license, you
** are using this software/code illegally and you do not
** have permission to use, modify, or redistribute
** this or any files in this software package.
**
** File: DataIO.h
**
**********************************************************/
#ifndef __DATAIO__
#define __DATAIO__

#include <iostream>
#include <string>
#include <vector>
using namespace std;

class CMatrixWriter
{
 public:
  virtual ~CMatrixWriter() {}
  virtual void Write(double** ppMatrix, int rowCount, int rowLength, ostream ostr) = 0;
};

class CDelimitedMatrixWriter
{
 public:
  CDelimitedMatrixWriter(char cDelim);
  CDelimitedMatrixWriter();

  void Write(double** ppMatrix, int rowCount, int rowLength, ostream &ostr);
 private:
  char m_cDelim;
};


typedef vector<double> TDoubleVector;

class CDelimitedMatrixReader
{
 public:
  CDelimitedMatrixReader(char cDelim);
  CDelimitedMatrixReader();

  void Read(istream &istr, int* pRowCount, int* pRowLength, double*** ppMatrix);
  void Read(istream &istr, int* pRowCount, int* pRowLength, TDoubleVector*** pppVectors);

 private:
  char m_cDelim;
};

#endif
