/*********************************************************
** Copyright (c) 2005
** University of Washington
** Licensed under the terms set forth by University of
** Washington. If you did not sign such a license, you
** are using this software/code illegally and you do not
** have permission to use, modify, or redistribute
** this or any files in this software package.
**
** File: UpperDiagonalMatrixTest.h
**
**********************************************************/
#ifndef __UPPERDIAGONALMATRIXTEST__
#define __UPPERDIAGONALMATRIXTEST__

#include "UnitTestClass.h"
#include "UpperDiagonalMatrix.h"

class CUpperDiagonalMatrixTest : public CUnitTestClass
{
 public:
  CUpperDiagonalMatrixTest() : CUnitTestClass("UpperDiagonalMatrixTest")
  {
  }

 protected:
  void RunTests()
  {
    TestUpperDiagonalMatrix();
  }

 private:
  void TestUpperDiagonalMatrix()
  {
    BeginTest("TestUpperDiagonalMatrix");
    bool success = true;
    CUpperDiagonalMatrix matrix = CUpperDiagonalMatrix(3);

    matrix.SetValue(0,1,5.0);
    matrix.SetValue(0,2,6.0);
    matrix.SetValue(1,2,7.0);

    if (matrix.GetValue(0,1) != 5.0 || 
	matrix.GetValue(0,2) != 6.0 ||
	matrix.GetValue(1,2) != 7.0 
	)
      success = false;
    
    EndTest(success);
  }

};

#endif
