/*********************************************************
** Copyright (c) 2005
** University of Washington
** Licensed under the terms set forth by University of
** Washington. If you did not sign such a license, you
** are using this software/code illegally and you do not
** have permission to use, modify, or redistribute
** this or any files in this software package.
**
** File: VectorTest.h
**
**********************************************************/
#ifndef __VECTORTEST__
#define __VECTORTEST__

#include "ClusterNodeVector.h"

class CVectorTest : public CUnitTestClass
{
 public:
  CVectorTest() : CUnitTestClass("VectorTest")
  {
  }

 protected:
  void RunTests()
  {
    TestPushBack();
  }

 private:
  void TestPushBack()
  {
    BeginTest("TestPushBack");
    bool success = true;

    try
    {
      CClusterNodeVector v(1);
      CClusterNode node1(NULL, 0);
      CClusterNode node2(NULL, 0);

      __test_assert(v.size() == 0, "v.size != 2");
      v.push_back(&node1);
      __test_assert(v.size() == 1, "v.size != 1");
      __test_assert(v.capacity() == 1, "v.capacity != 1");

      CClusterNodeVector::iterator it = v.begin();
      int count = 0;
      for(;it != v.end(); it++, count++)
	{
	  if(count == 0)
	    {
	      __test_assert((*it) == &node1, "first vector element was not = &node1");
	    }
	}
      if (count != 1)
	cout << "count = " << count << "\n";

      __test_assert(count == 1, "count != 1");

      do {
	try {
	  v.push_back(&node2);
	  // If this succeeded, then the test has failed.
	  success = false;
	}
	catch(invalid_index&) {
	}
      } while(0);

    }
    catch(CTestException *pEx)
    {
      success = false;
      cout << pEx->Message() << "\n";
      delete pEx;
    }
    catch(...)
    {
      success = false;
      cout << "something's wrong\n";
    }
    
    EndTest(success);
  }

};

#endif
