/*********************************************************
** Copyright (c) 2005
** University of Washington
** Licensed under the terms set forth by University of
** Washington. If you did not sign such a license, you
** are using this software/code illegally and you do not
** have permission to use, modify, or redistribute
** this or any files in this software package.
**
** File: VectorTestClasses.cpp
**
**********************************************************/
#include "VectorTestClasses.h"
#include <cmath>
#include "SafeInt.h"
#include "ClusterException.h"

CVectorToStream::CVectorToStream() : m_pStream(&cout) {}
CVectorToStream::CVectorToStream(ostream* str) : m_pStream(str) {}

void CVectorToStream::Go(CClusterNode* pNode)
{
  if(NULL == m_pStream)
    __throw_cluster_ex(CLUSTEX_NULLARG, "m_pStream is NULL");

  if(NULL == pNode)
    __throw_cluster_ex(CLUSTEX_NULLARG, "pNode is NULL");
  
  TDoubleVector* vec = (TDoubleVector*)pNode->GetData();
  if (NULL == vec)
    __throw_cluster_ex(CLUSTEX_OUTOFMEMORY, "");
  
  for(TDoubleVector::iterator i = vec->begin(); i != vec->end(); i++)
    {
      (*m_pStream) << *i << '\t';
    }
  (*m_pStream) << '\n';
}

CVectorArrayBuilder::CVectorArrayBuilder()
{
}

void CVectorArrayBuilder::Go(CClusterNode* pNode)
{
  if (NULL == pNode)
    __throw_cluster_ex(CLUSTEX_NULLARG, "pNode is NULL");

  TDoubleVector* pVect = (TDoubleVector*)pNode->GetData();
  if (NULL == pVect)
    __throw_cluster_ex(CLUSTEX_NULLARG, "pVect is NULL");

  m_vectors.push_back(pVect);
}

vector<TDoubleVector*> CVectorArrayBuilder::GetVectors()
{
  return m_vectors;
}

