/*********************************************************
** Copyright (c) 2005
** University of Washington
** Licensed under the terms set forth by University of
** Washington. If you did not sign such a license, you
** are using this software/code illegally and you do not
** have permission to use, modify, or redistribute
** this or any files in this software package.
**
** File: VectorTestClasses.h
**
**********************************************************/
#ifndef __VECTORTESTCLASSES__
#define __VECTORTESTCLASSES__

#include <vector>
#include <iostream>
#include <stdint.h>
using namespace std;

#include "VectorDataFunctions.h"
#include "ClusterNode.h"
#include "Cluster.h"

class CVectorToStream : public CClusterNodeFunction
{
 public:
  CVectorToStream();
  CVectorToStream(ostream* str);
  virtual ~CVectorToStream() {}

  void Go(CClusterNode* pNode);

 private:
  ostream* m_pStream;

};

class CVectorArrayBuilder : public CClusterNodeFunction
{
 public:
  CVectorArrayBuilder();
  virtual ~CVectorArrayBuilder() {}

  void Go(CClusterNode* pNode);
  vector<TDoubleVector*> GetVectors();

 private:
  vector<TDoubleVector*> m_vectors;

};

#endif
