/*********************************************************
** Copyright (c) 2005
** University of Washington
** Licensed under the terms set forth by University of
** Washington. If you did not sign such a license, you
** are using this software/code illegally and you do not
** have permission to use, modify, or redistribute
** this or any files in this software package.
**
** File: main.cpp
**
**********************************************************/
#include "UnitTestRunner.h"
#include "UpperDiagonalMatrixTest.h"
#include "ClusterNodeTest.h"
#include "ClusterTest.h"
#include "DataReaderTest.h"
#include "VectorDataFunctionsTest.h"
#include "OrderingTest.h"
#include "CallbackTest.h"
#include "SortTest.h"
#include "VectorTest.h"
#include "SafeIntTest.h"

#include <cerrno>
#ifdef WIN32
#else
#include <libgen.h>
#endif
#include <iostream>

using namespace std;

int main(int argc, char** argv)
{
  assert(argv > 0);

#ifndef WIN32
  int en;
  char* exename = argv[0];
  cout << "exename = " << exename << "\n";

  char* wdirname = dirname(exename);
  if (NULL == wdirname)
    {
      en = errno;
      cout << "Call to dirname('" << exename << "') failed with errno = " 
	   << en << "\n";
    }

  if (chdir(wdirname) < 0)
    {
      en = errno;
      cout << "Call to chdir('" << wdirname << "') failed with errno = " 
	   << en << "\n";
    }
#endif

  CUnitTestRunner runner;
  runner.AddObject(new CSafeIntTest(), "CSafeIntTest");
  runner.AddObject(new CVectorTest(), "CVectorTest");
  runner.AddObject(new CUpperDiagonalMatrixTest(), "CUpperDiagonalMatrixTest");
  runner.AddObject(new CClusterNodeTest(), "CClusterNodeTest");
  runner.AddObject(new CClusterTest(), "CClusterTest");
  runner.AddObject(new CDataReaderTest(), "CDataReaderTest");
  runner.AddObject(new CVectorDataFunctionsTest(), "CVectorDataFunctionsTest");
  runner.AddObject(new COrderingTest(), "COrderingTest");
  runner.AddObject(new CCallbackTest(), "CCallbackTest");
  runner.AddObject(new CSortTest(), "CSortTest");
  int result = runner.Run();
  runner.DeleteTests();

  return result;

}
