/*********************************************************
** Copyright (c) 2005
** University of Washington
** Licensed under the terms set forth by University of
** Washington. If you did not sign such a license, you
** are using this software/code illegally and you do not
** have permission to use, modify, or redistribute
** this or any files in this software package.
**
** File: UpperDiagonalMatrix.h
**
**********************************************************/
#ifndef __CUPPERDIAGONALMATRIX__
#define  __CUPPERDIAGONALMATRIX__

#include <assert.h>
#include "Matrix.h"
#include <stdint.h>

/*
 * Class for storing an upper diagonal matrix.
 */

class CUpperDiagonalMatrix : public CMatrix
{
 public:
  /* Returns number of bytes required to construct a matrix of given size */
  static uintmax_t GetMemoryRequirement(uintmax_t size);

  CUpperDiagonalMatrix(int size);
  virtual ~CUpperDiagonalMatrix();

  void SetValue(int i, int j, double value);
  double GetValue(int i, int j);

 private:
  double** m_ppMatrix;
  int m_iSize;
  int m_iConst;
  int m_iLength;
};
#endif 
