/*********************************************************
** Copyright (c) 2005
** University of Washington
** Licensed under the terms set forth by University of
** Washington. If you did not sign such a license, you
** are using this software/code illegally and you do not
** have permission to use, modify, or redistribute
** this or any files in this software package.
**
** File: debug.c
**
**********************************************************/
#include "debug.h"
#include <stdio.h>
#include <stdarg.h>

#ifdef EDGE_DEBUG
#define EDGE_DEBUG_FILE "debug_log.txt"
void debug_log(const char* format, ...)
{
  va_list args;

  FILE* f = fopen(EDGE_DEBUG_FILE, "a");
  if (NULL == f)
    return;

  va_start(args, format);
  int chars = vfprintf(f, format, args);
  fprintf(f, "\n");
  va_end(args);

  fclose(f);
}
void saveDblArray(const char* fileName, double* pArray, long length)
{
  FILE* f = fopen(fileName, "w");
  if(NULL == f)
    {
      debug_log("could not open file %s for writing", fileName);
      return;
    }

  fprintf(f, "length = %ld\n", length);
  long i;
  for(i = 0; i < length; i++)
    {
      fprintf(f, "%f\n", pArray[i]);
    }

  fclose(f);
}

void saveIntArray(const char* fileName, int* pArray, long length)
{
  FILE* f = fopen(fileName, "w");
  if(NULL == f)
    {
      debug_log("could not open file %s for writing", fileName);
      return;
    }

  fprintf(f, "length = %ld\n", length);
  long i;
  for(i = 0; i < length; i++)
    {
      fprintf(f, "%d\n", pArray[i]);
    }

  fclose(f);
}

#else
inline void debug(const char* format, ...) {}
inline void saveDblArray(const char* fileName, double* pArray, long length) {}
inline void saveIntArray(const char* fileName, int* pArray, long length) {}
#endif

