/*********************************************************
** Copyright (c) 2005
** University of Washington
** Licensed under the terms set forth by University of
** Washington. If you did not sign such a license, you
** are using this software/code illegally and you do not
** have permission to use, modify, or redistribute
** this or any files in this software package.
**
** File: edge.h  $Revision: 253 $
**
**********************************************************/
#include <stdio.h>/* --------- printf */
#include <stdlib.h>/* -------- malloc(), free(), etc. */
#include <math.h>/* ---------- log(), exp(), etc. */
#include <Rmath.h>/* ------------- R functions */

#define NR_END 1
#define FREE_ARG void*
#include "ProgressThreadDef.h"

#ifdef __cplusplus
extern "C" {
#endif

/***********************************************************************
 * EDGE-specific functions
 ***********************************************************************/
void odp(double *, double *, double *, double *, long *, long *, long *, 
   int *, long *, long *, int *, double *, 
  update_progress_routine*, void*, double *, double *);

double odp1t(long m, long m0, long n, long k);
void odp1(long m, long m0, long n, long k,
     double *xx, double *xk, double *mu, double *sigma,
     int *nGrp, int *nii,
     double *scr, update_progress_routine* callback, void* callbackArg,
     double *currentStart, double *maxStart);

double odp2t(long m, long m0, long n, long k);
void odp2(long m, long m0, long n, long k,
     double *xx, double *xk, double *mu, double *sigma,
     int *nGrp, int *nii,
     double *scr, update_progress_routine* callback, void* callbackArg,
     double *currentStart, double *maxStart);

double odp3t(long m, long m0, long n, long k);
double odp4t(long m, long m0, long n, long k);


void nullODP(long, long, long, long, long, double *, double *, double *, 
  double *, int *, int *, int *, int *,  
  double *, update_progress_routine*, void*, double *, double *);

void nullFIndep(double *, double *, int *, double *, double *, long *, 
   long *, long *, double *,
   update_progress_routine* callback, void *callbackArg);

void nullFLongNoInt(double *fitR, double *resR, int *vR, int *rmv, 
   int *inc, double *H1R, double *H0R, double *wsqR, int *ind, 
   int *idx, long *m, long *n, long *N, int *nGrp, long *B, double *F,
   update_progress_routine* callback, void* callbackArg);

void nullFLongInt(double *fitR, double *resR, int *vR, int *v1R, double *H1R,
   double *H0R, double *alphaR, int *ind, int *idx, double *eps, 
   long *m, long *n, long *N, int *nGrp, long *B, double *F,
   update_progress_routine* callback, void* callbackArg);

void FNoEM(double **, double **, double **, double **, double **, 
   double *, double *, long *, long *, double *,
   update_progress_routine* callback, void *callbackArg,
   double *currentStart, double *maxStart);

void FEM(double **dat, double **H1, double **H0, int *ind, int *idx, 
   double *eps, double **fit1, double **fit0, double **alpha1, double **alpha0, 
   double *rss1, double *rss0, double **datC, double *gm, double **A0, 
   double **AA0, double **AA, double *lik0, double *lik, double *tau, 
   double *sig, long *EM, double *atmp, long *m, long *n, 
   long *N, int *nGrp, double *F, update_progress_routine* callback, 
   void* callbackArg, double *pMax, double *pCurrent);

void EMFit(double **dat, double **H, int *ind, int *idx, double *eps, 
   double **fit, double **alpha, double **datC, double *gm, 
   double **A0, double **AA0, double **AA, double *lik0, double *lik, 
   double *tau, double *sig, long *EM, double *atmp, long *m, long *n, 
   long *N, int *nGrp, long *iter, update_progress_routine* callback, 
   void* callbackArg, double *pMax, double *pCurrent);

void EMFitR(double *datR, double *HR, int *ind, int *idx, double *eps, 
   double *fitR, double *alphaR, 
   long *m, long *n, long *N, int *nGrp, long *iter);

/***********************************************************************
utility functions 
***********************************************************************/
void sortQK(long, long, long, double *);
void swapQK(long, long, double *);
double *vector(long, long);
void free_vector(double *, long, long);
int *intvector(long, long);
void free_intvector(int *, long, long);
long *ivector(long, long);
void free_ivector(long *, long, long);
double **matrix(long, long, long, long);
void free_matrix(double **, long, long, long, long);
long **imatrix(long, long, long, long);
void free_imatrix(long **, long, long, long, long);

#ifdef __cplusplus
}
#endif
