### This script generates a large dataset and saves it as a file.

### Dimensions.
rows <- 20000
cols <- 228

### Names for rows and columns.
rowname.base <- "gene"
colname.base <- "array"

### Files to be saved.
filename <- "verylarge.txt"
covfilename <- "verylarge_cov.txt"

### Covariate dimensions
cov.dims <- 4:1

### Random seed.
seed <- 5257122

print("Set random seed.")
set.seed(seed)

print("Generate random numbers for expression data.")
m <- matrix(rnorm(rows*cols), nrow=rows)

print(paste("Generate", cols, "column names and", rows, "row names."))
dimnames(m) <- list(rownames=paste(rowname.base, 1:rows), colnames=paste(colname.base, 1:cols))

print("Save expression data.")
cat("\"Gene Name\"\t", file=filename)
write.table(m, file=filename, sep="\t", append=T)

print("Generate covariates.")
covs <- matrix(c(1:(cols*length(cov.dims))), nrow=length(cov.dims))
for( i in 1:length(cov.dims)) {
  covs[i,] <- paste("cov", i, "_", sample(1:cov.dims[i], cols, replace=T), sep="")
}

dimnames(covs) <- list(paste("Covariate with", cov.dims, "dimensions"), 1:cols)

print("Save covariates.")
cat("\"Covariates\"\t", file=covfilename)
write.table(covs, file=covfilename, sep="\t", append=T)
