source("testfunctions.r")

test.assert.tables.equal.1 <- function() {
  m1 <- matrix(1:12, nrow=3)
  m2 <- m1
  assert.tables.equal(m1, m2, "Should be equal here")
}

test.assert.tables.equal.2 <- function() {
  m1 <- matrix(1:12, nrow=3)
  m2 <- m1
  m2[3,1] = 27
  
  ## Expect an error
  err <- NULL
  tryCatch(assert.tables.equal(m1, m2), error=function(e) err <<- e)
  expected = "assert.tables.equal failed:  assert.tables.equal m1 m2 The following rows are different: 3 (comment: )"
  if(is.null(err)) {
    stop("Expected an error but didn't get one")
  } else {
    if (err$message != expected)
      stop(paste("Got a different error than expected: ", err$message))
    
  }
}

test.assert.tables.equal.3 <- function() {
  m1 <- matrix(1:12, nrow=3)
  m2 <- m1
  m2[3,1] = 27
  m1[2,2] = 48
  
  ## Expect an error
  err <- NULL
  tryCatch(assert.tables.equal(m1, m2, "Comment"), error=function(e) err <<- e)
  expected = "assert.tables.equal failed:  assert.tables.equal m1 m2 Comment The following rows are different: 2 3 (comment: Comment)"
  if(is.null(err)) {
    stop("Expected an error but didn't get one")
  } else {
    if (substr(err$message, 0, nchar(expected)) != expected)
      stop(paste("Got a different error than expected: ", err))
  }
}

test.assert.tables.equal.4 <- function() {
  m1 <- matrix(1:12, nrow=3)
  m2 <- matrix(1:16, nrow=4)
  
  ## Expect an error
  err <- NULL
  tryCatch(assert.tables.equal(m1, m2, "Comment"), error=function(e) err <<- e)
  expected = "assert.tables.equal failed:  assert.tables.equal m1 m2 Comment t1 has 3 rows, t2 has 4 (comment: Comment)"
  if(is.null(err)) {
    stop("Expected an error but didn't get one")
  } else {
    if (substr(err$message, 0, nchar(expected)) != expected)
      stop(paste("Got a different error than expected: ", err))
  }
}

test.assert.tables.equal.5 <- function() {
  m1 <<- matrix((1:12)+0.1, nrow=3)
  m2 <<- m1
  assert.tables.equal(m1, m2, tolerance=0.001)
  m1[3,2] <- m2[3,2] + 0.0001
  assert.tables.equal(m1, m2, tolerance=0.001)
  
  ## Expect an error
  err <- NULL
  tryCatch(assert.tables.equal(m1, m2, "Comment", tolerance=0.00001), error=function(e) err <<- e)
  expected = "assert.tables.equal failed:  assert.tables.equal m1 m2 Comment 1e-05 The following rows are different: 3 (comment: Comment)"
  if(is.null(err)) {
    stop("Expected an error but didn't get one")
  } else {
    if (substr(err$message, 0, nchar(expected)) != expected)
      stop(paste("Got a different error than expected: ", err))
  }

}

test.assert.tables.equal.6 <- function() {
  m1 <<- matrix(paste("string", (1:12)+0.1), nrow=3)
  m2 <<- m1
  assert.tables.equal(m1, m2, tolerance=0.001)

  m1[3,2] <- "What"
  
  ## Expect an error
  err <- NULL
  tryCatch(assert.tables.equal(m1, m2, "Comment", tolerance=0.00001), error=function(e) err <<- e)
  expected = "assert.tables.equal failed:  assert.tables.equal m1 m2 Comment 1e-05 The following rows are different: 3 (comment: Comment)"
  if(is.null(err)) {
    stop("Expected an error but didn't get one")
  } else {
    if (substr(err$message, 0, nchar(expected)) != expected)
      stop(paste("Got a different error than expected: ", err))
  }

}

