dir <- getwd()
setwd("../..")
source("util.r")
source("include.r")
setwd(dir)
source("testfunctions.r")

test.readexpr.basic <- function()
{
  geneNames <- c(paste("r", 1:4))
  arrayNames <- c(paste("col", 1:3))
  data <- matrix(c(1:12), nrow=4, byrow=TRUE)
  expr <- matrix(c("nothing", arrayNames, geneNames[1], 1:3, geneNames[2],  4:6, geneNames[3], 7:9, geneNames[4], 10:12), byrow=TRUE, ncol=4)
  expr.file <- "tmp.txt"
  f <- file(expr.file, "w")
  for(i in 1:nrow(expr))
  {
    cat(expr[i,], file=f, sep="\t")
    cat("\n", file=f)
  }
  close(f)

  expr.data <- readexpr.func(expr.file)
  assert(is.list(expr.data))
  assert(class(expr.data)=="edge.expr.data")
  assert(sum(expr.data$geneNames != geneNames) == 0)
  assert(sum(expr.data$expr.data != data) == 0)
  assert(is.null(expr.data$annotate))
}

test.readexpr.description <- function()
{
  geneNames <- c(paste("r", 1:4))
  arrayNames <- c(paste("col", 1:3))
  descs <- c(paste("desc", 1:4))
  data <- matrix(c(1:12), nrow=4, byrow=TRUE)
  expr <- matrix(c("nothing", "desc", arrayNames,
                   geneNames[1], descs[1], 1:3,
                   geneNames[2], descs[2],  4:6,
                   geneNames[3], descs[3], 7:9,
                   geneNames[4], descs[4], 10:12),
                 byrow=TRUE, ncol=5)
  expr.file <- "tmp.txt"
  f <- file(expr.file, "w")
  for(i in 1:nrow(expr))
  {
    cat(expr[i,], file=f, sep="\t")
    cat("\n", file=f)
  }
  close(f)

  expr.data <- readexpr.func(expr.file, description.column=TRUE)
  assert(is.list(expr.data))
  assert(class(expr.data)=="edge.expr.data")
  assert(all(expr.data$geneNames == geneNames))
  assert(all(expr.data$expr.data == data))
  assert(all(expr.data$annotate == descs))
}

test.readwriteexpr <- function()
{
  data1 <- readexpr.func("../../data/endo.txt")
  writeexpr.func("tmpendo.txt", data1$exprs, data1$geneNames, NULL)
  data2 <- readexpr.func("tmpendo.txt")
  assert(sum(data1$exprs != data2$exprs) == 0)
  assert(sum(data1$geneNames != data2$geneNames) == 0)
}

test.concat.matrices <- function()
{
  m1 <- matrix(c(1:12), nrow=3, byrow=TRUE)
  m2 <- matrix(c(13:24), nrow=3, byrow=TRUE)
  expected.concat <- matrix(c(1:24), nrow=6, byrow=TRUE)
  concat <- concat.matrices(m1, m2)
  assert(sum(expected.concat-concat) == 0)

  concat <- concat.matrices(m1, NULL)
  assert(all(m1==concat))

  concat <- concat.matrices(NULL, m1)
  assert(all(m1==concat))

  concat <- concat.matrices(NULL, NULL)
  assert(is.null(concat))
}

test.check.numeric.pass <- function()
{
  check.numeric(c(1.23, 4.32))
}

test.check.numeric.fail <- function()
{
  err <- NULL
  tryCatch(check.numeric(c("sheep", 3)),
           error=function(e) err <<- e)
  assert(!is.null(err))
}

test.make.consecutive.int.1 <- function()
{
  a <- c("sheep", "sheep", "goat", "cat", "zebra", "cat")
  expected.int <- c(3, 3, 2, 1, 4, 1)
  actual.int <- make.consecutive.int(a)
  assert(all(actual.int == expected.int))
}

test.make.consecutive.int.2 <- function()
{
  a <- c(500, 8, 24, 99, 8, 24)
  expected.int <- c(2,3,1,4,3,1)
  actual.int <- make.consecutive.int(a)
  assert(all(actual.int == expected.int))
}

test.make.consecutive.int.3 <- function()
{
  a <- c(500.234, 8.22, 24.22, 24.23, 8.22, 24.23)
  expected.int <- c(3,4,1,2,4,2)
  actual.int <- make.consecutive.int(a)
  assert(all(actual.int == expected.int))
}

### Verify that quick.order() returns the same results as "order"
### on a bunch of vectors
test.quick.order.1 <- function()
{
  a <- c(500.234, 8.22, 24.22, 24.23, 8.12, 24.24)
  expected.ord <<- order(a, decreasing = F)
  ord <<- quick.order(a, decreasing = F)
  assert(all(expected.ord==ord), "a increasing")

  expected.ord <- order(a, decreasing = T)
  ord <- quick.order(a, decreasing = T)
  assert(all(expected.ord==ord), "a decreasing")
  
}

test.removequotes.1 <- function() {
  assert(removequotes("") == "")
  assert(is.null(removequotes(NULL)))
  assert(removequotes("abc") == "abc")
  assert(removequotes("\"abc\"") == "abc")
  assert(removequotes("\"a\"b\"c") == "a\"b\"c")
}


test.trim.1 <- function() {
  assert(trim("") == "")
  assert(trim(" ") == "")
  assert(trim("\t ") == "")
  assert(trim(" \tabc  ") == "abc")
}

test.is.valid.number <- function() {
  assert(!is.valid.number(NA))
  assert(!is.valid.number(NULL))
  assert(!is.valid.number(Inf))
  assert(!is.valid.number(NaN))
  assert(!is.valid.number("string"))
  assert(!is.valid.number(list()))
  assert(is.valid.number(23))
  assert(is.valid.number(0))
  assert(is.valid.number(pi))
}

test.sort.na.last <- function() {
  a <- c(20, 10, NA, NaN, 30, Inf, NaN, NA)
  b <- a[sort.na.last(a)]
  assert(all(b[1:3]==c(10,20,30)))
  assert(is.infinite(b[4]))
  assert(all(is.na(b[5:8])))


  if(exists("longvec"))
    rm("longvec")
  load("data/test_sort_na_lastsm.RData")
  assert(exists("longvec"))

  nacount <- sum(is.na(longvec))
  sorted.ix <- sort.na.last(longvec)
  sorted.x <- longvec[sorted.ix]
  assert(length(sorted.x)==length(longvec))
  assert(!any(is.na(sorted.x[1:(length(sorted.x)-nacount)])))
}

test.readcov.1 <- function() {
  ## Read a covariate file with only one covariate
  covs.input <- matrix(c("Array", "Array1", "Mutation", "BRCA1"), nrow=2, byrow=TRUE)
  filename <- "tmp_test_readcov_1.txt"
  write.table(covs.input, file=filename,row.names=FALSE,col.names=FALSE,sep="\t")

  covs.output <<- readcov.func(filename)
  assert(is.list(covs.output))
  assert(is.matrix(covs.output$covData))
  assert(all(dim(covs.output$covData)==c(1,1)))
  assert(covs.output$covData[1,1]=="BRCA1")
  assert(rownames(covs.output$covData)=="Mutation")
  assert(names(covs.output$covData)=="Array1")
  assert(covs.output$varLabels=="Mutation")
  assert(class(covs.output) == "edge.expr.covariates")
}

test.readcov.2 <- function() {
  ## Read a covariate file with only one covariate
  covs.input <- matrix(c("Array", "Array1", "Array2", "Mutation", "BRCA1", "BRCA2"), nrow=2, byrow=TRUE)
  filename <- "tmp_test_readcov_2.txt"
  write.table(covs.input, file=filename,row.names=FALSE,col.names=FALSE,sep="\t")

  covs.output <<- readcov.func(filename)
  assert(is.list(covs.output))
  assert(is.data.frame(covs.output$covData))
  assert(all(dim(covs.output$covData)==c(1,2)))
  assert(all(covs.output$covData[1,]==c("BRCA1", "BRCA2")))
  assert(rownames(covs.output$covData)=="Mutation")
  assert(all(names(covs.output$covData)==c("Array1","Array2")))
  assert(all(covs.output$varLabels=="Mutation"))
  assert(class(covs.output) == "edge.expr.covariates")
}

