/*********************************************************
** Copyright (c) 2005
** University of Washington
** Licensed under the terms set forth by University of
** Washington. If you did not sign such a license, you
** are using this software/code illegally and you do not
** have permission to use, modify, or redistribute
** this or any files in this software package.
**
** File: Clock.c
**
**********************************************************/
#include "Clock.h"

#ifdef WIN32
#include <Windows.h>
#endif

CLOCK_T get_time()
{
#ifdef WIN32
  return GetTickCount();
#else
  return clock();
#endif
}

long get_time_diff_milliseconds(CLOCK_T a, CLOCK_T b)
{
#ifdef WIN32
  return (long)(b - a);
#else
  return (long)((b - a)/CLOCKS_PER_SEC)*1000L;
#endif
}
