/*********************************************************
** Copyright (c) 2005
** University of Washington
** Licensed under the terms set forth by University of
** Washington. If you did not sign such a license, you
** are using this software/code illegally and you do not
** have permission to use, modify, or redistribute
** this or any files in this software package.
**
** File: Clock.h
**
**********************************************************/
#ifndef CLOCK_H
#define CLOCK_H

#ifdef __cplusplus
extern "C" {
#endif

  /* Clock functions */
#ifdef WIN32
#include <windef.h>
#define CLOCK_T DWORD
#else
#include <time.h>
#define CLOCK_T clock_t
#endif

CLOCK_T get_time();
long get_time_diff_milliseconds(CLOCK_T a, CLOCK_T b);

#ifdef __cplusplus
}
#endif

#endif
