/*********************************************************
** Copyright (c) 2005
** University of Washington
** Licensed under the terms set forth by University of
** Washington. If you did not sign such a license, you
** are using this software/code illegally and you do not
** have permission to use, modify, or redistribute
** this or any files in this software package.
**
** File: IProgressThreadCallback.h
**
**********************************************************/
#ifndef IPROGRESSTHREADCALLBACK_H
#define IPROGRESSTHREADCALLBACK_H
#include "ProgressThread.h"
#include "ProgressThreadDef.h"

class IProgressThreadCallback
{
 public:
  IProgressThreadCallback() : m_ptCallback(NULL), m_pArg(NULL) {}
  virtual ~IProgressThreadCallback() {}

  virtual void SetCallback(update_progress_routine* callback, void* arg) 
  { 
    m_ptCallback = callback; 
    m_pArg = arg;
  }
  virtual update_progress_routine* GetCallback() { return m_ptCallback; }
  virtual void* GetCallbackArg() { return m_pArg; }
  virtual void DoCallback(double max, double current, int msgid) 
  { 
    if (NULL != m_ptCallback) m_ptCallback((void*)m_pArg, max, current, msgid);
  }

 private:
  update_progress_routine* m_ptCallback;
  void* m_pArg;
};

#endif

