/*********************************************************
** Copyright (c) 2005
** University of Washington
** Licensed under the terms set forth by University of
** Washington. If you did not sign such a license, you
** are using this software/code illegally and you do not
** have permission to use, modify, or redistribute
** this or any files in this software package.
**
** File: ProgressThreadDef.h
**
**********************************************************/
#ifndef PROGRESSTHREADDEF_H
#define PROGRESSTHREADDEF_H

#ifdef __cplusplus
extern "C" {
#endif

typedef void update_progress_routine(void* arg, double max, double current, int msgid);
typedef void cleanup_routine(void* arg);
void do_callback(update_progress_routine* routine, void* arg, double max, double current, int msgid);

#ifdef WIN32
#include <windef.h>
#define THREAD_ID_T DWORD
#define THREADPROC_RETURN_TYPE DWORD
#define THREADPROC_ARG_TYPE LPVOID
#define THREAD_SELF GetCurrentThreadId
#else
#define THREAD_ID_T pthread_t
#define THREADPROC_RETURN_TYPE void*
#define THREADPROC_ARG_TYPE void*
#define THREAD_SELF pthread_self
#endif


#ifdef __cplusplus
}
#endif

#endif
